package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MeteredConnectionLimitType implements Enum {

    @JsonProperty("unrestricted")
    UNRESTRICTED("unrestricted", "0"),

    @JsonProperty("fixed")
    FIXED("fixed", "1"),

    @JsonProperty("variable")
    VARIABLE("variable", "2");

    private final String name;
    private final String value;

    private MeteredConnectionLimitType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
