package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MeetingCapabilities implements Enum {

    @JsonProperty("questionAndAnswer")
    QUESTION_AND_ANSWER("questionAndAnswer", "0"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "1");

    private final String name;
    private final String value;

    private MeetingCapabilities(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
