package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MediaDirection implements Enum {

    @JsonProperty("inactive")
    INACTIVE("inactive", "0"),

    @JsonProperty("sendOnly")
    SEND_ONLY("sendOnly", "1"),

    @JsonProperty("receiveOnly")
    RECEIVE_ONLY("receiveOnly", "2"),

    @JsonProperty("sendReceive")
    SEND_RECEIVE("sendReceive", "3");

    private final String name;
    private final String value;

    private MediaDirection(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
