package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MdmAuthority implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("intune")
    INTUNE("intune", "1"),

    @JsonProperty("sccm")
    SCCM("sccm", "2"),

    @JsonProperty("office365")
    OFFICE365("office365", "3");

    private final String name;
    private final String value;

    private MdmAuthority(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
