package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MdmAppConfigKeyType implements Enum {

    @JsonProperty("stringType")
    STRING_TYPE("stringType", "0"),

    @JsonProperty("integerType")
    INTEGER_TYPE("integerType", "1"),

    @JsonProperty("realType")
    REAL_TYPE("realType", "2"),

    @JsonProperty("booleanType")
    BOOLEAN_TYPE("booleanType", "3"),

    @JsonProperty("tokenType")
    TOKEN_TYPE("tokenType", "4");

    private final String name;
    private final String value;

    private MdmAppConfigKeyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
