package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ManagementState implements Enum {

    @JsonProperty("managed")
    MANAGED("managed", "0"),

    @JsonProperty("retirePending")
    RETIRE_PENDING("retirePending", "1"),

    @JsonProperty("retireFailed")
    RETIRE_FAILED("retireFailed", "2"),

    @JsonProperty("wipePending")
    WIPE_PENDING("wipePending", "3"),

    @JsonProperty("wipeFailed")
    WIPE_FAILED("wipeFailed", "4"),

    @JsonProperty("unhealthy")
    UNHEALTHY("unhealthy", "5"),

    @JsonProperty("deletePending")
    DELETE_PENDING("deletePending", "6"),

    @JsonProperty("retireIssued")
    RETIRE_ISSUED("retireIssued", "7"),

    @JsonProperty("wipeIssued")
    WIPE_ISSUED("wipeIssued", "8"),

    @JsonProperty("wipeCanceled")
    WIPE_CANCELED("wipeCanceled", "9"),

    @JsonProperty("retireCanceled")
    RETIRE_CANCELED("retireCanceled", "10"),

    @JsonProperty("discovered")
    DISCOVERED("discovered", "11");

    private final String name;
    private final String value;

    private ManagementState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
