package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ManagedDeviceRemoteAction implements Enum {

    @JsonProperty("retire")
    RETIRE("retire", "0"),

    @JsonProperty("delete")
    DELETE("delete", "1"),

    @JsonProperty("fullScan")
    FULL_SCAN("fullScan", "2"),

    @JsonProperty("quickScan")
    QUICK_SCAN("quickScan", "3"),

    @JsonProperty("signatureUpdate")
    SIGNATURE_UPDATE("signatureUpdate", "4"),

    @JsonProperty("wipe")
    WIPE("wipe", "5"),

    @JsonProperty("customTextNotification")
    CUSTOM_TEXT_NOTIFICATION("customTextNotification", "6"),

    @JsonProperty("rebootNow")
    REBOOT_NOW("rebootNow", "7"),

    @JsonProperty("setDeviceName")
    SET_DEVICE_NAME("setDeviceName", "8"),

    @JsonProperty("syncDevice")
    SYNC_DEVICE("syncDevice", "9");

    private final String name;
    private final String value;

    private ManagedDeviceRemoteAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
