package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ManagedDeviceOwnerType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("company")
    COMPANY("company", "1"),

    @JsonProperty("personal")
    PERSONAL("personal", "2");

    private final String name;
    private final String value;

    private ManagedDeviceOwnerType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
