package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ManagedAppRemediationAction implements Enum {

    @JsonProperty("block")
    BLOCK("block", "0"),

    @JsonProperty("wipe")
    WIPE("wipe", "1"),

    @JsonProperty("warn")
    WARN("warn", "2");

    private final String name;
    private final String value;

    private ManagedAppRemediationAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
