package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ManagedAppPhoneNumberRedirectLevel implements Enum {

    @JsonProperty("allApps")
    ALL_APPS("allApps", "0"),

    @JsonProperty("managedApps")
    MANAGED_APPS("managedApps", "1"),

    @JsonProperty("customApp")
    CUSTOM_APP("customApp", "2"),

    @JsonProperty("blocked")
    BLOCKED("blocked", "3");

    private final String name;
    private final String value;

    private ManagedAppPhoneNumberRedirectLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
