package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ManagedAppNotificationRestriction implements Enum {

    @JsonProperty("allow")
    ALLOW("allow", "0"),

    @JsonProperty("blockOrganizationalData")
    BLOCK_ORGANIZATIONAL_DATA("blockOrganizationalData", "1"),

    @JsonProperty("block")
    BLOCK("block", "2");

    private final String name;
    private final String value;

    private ManagedAppNotificationRestriction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
