package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ManagedAppDataStorageLocation implements Enum {

    @JsonProperty("oneDriveForBusiness")
    ONE_DRIVE_FOR_BUSINESS("oneDriveForBusiness", "1"),

    @JsonProperty("sharePoint")
    SHARE_POINT("sharePoint", "2"),

    @JsonProperty("localStorage")
    LOCAL_STORAGE("localStorage", "6");

    private final String name;
    private final String value;

    private ManagedAppDataStorageLocation(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
