package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ManagedAppDataIngestionLocation implements Enum {

    @JsonProperty("oneDriveForBusiness")
    ONE_DRIVE_FOR_BUSINESS("oneDriveForBusiness", "1"),

    @JsonProperty("sharePoint")
    SHARE_POINT("sharePoint", "2"),

    @JsonProperty("camera")
    CAMERA("camera", "3");

    private final String name;
    private final String value;

    private ManagedAppDataIngestionLocation(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
