package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ManagedAppDataEncryptionType implements Enum {

    @JsonProperty("useDeviceSettings")
    USE_DEVICE_SETTINGS("useDeviceSettings", "0"),

    @JsonProperty("afterDeviceRestart")
    AFTER_DEVICE_RESTART("afterDeviceRestart", "1"),

    @JsonProperty("whenDeviceLockedExceptOpenFiles")
    WHEN_DEVICE_LOCKED_EXCEPT_OPEN_FILES("whenDeviceLockedExceptOpenFiles", "2"),

    @JsonProperty("whenDeviceLocked")
    WHEN_DEVICE_LOCKED("whenDeviceLocked", "3");

    private final String name;
    private final String value;

    private ManagedAppDataEncryptionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
