package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MailboxRecipientType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("user")
    USER("user", "1"),

    @JsonProperty("linked")
    LINKED("linked", "2"),

    @JsonProperty("shared")
    SHARED("shared", "3"),

    @JsonProperty("room")
    ROOM("room", "4"),

    @JsonProperty("equipment")
    EQUIPMENT("equipment", "5"),

    @JsonProperty("others")
    OTHERS("others", "6");

    private final String name;
    private final String value;

    private MailboxRecipientType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
