package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MacOSProcessIdentifierType implements Enum {

    @JsonProperty("bundleID")
    BUNDLE_ID("bundleID", "1"),

    @JsonProperty("path")
    PATH("path", "2");

    private final String name;
    private final String value;

    private MacOSProcessIdentifierType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
