package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MacOSContentCachingParentSelectionPolicy implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("roundRobin")
    ROUND_ROBIN("roundRobin", "1"),

    @JsonProperty("firstAvailable")
    FIRST_AVAILABLE("firstAvailable", "2"),

    @JsonProperty("urlPathHash")
    URL_PATH_HASH("urlPathHash", "3"),

    @JsonProperty("random")
    RANDOM("random", "4"),

    @JsonProperty("stickyAvailable")
    STICKY_AVAILABLE("stickyAvailable", "5");

    private final String name;
    private final String value;

    private MacOSContentCachingParentSelectionPolicy(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
