package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum MacOSContentCachingClientPolicy implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("clientsInLocalNetwork")
    CLIENTS_IN_LOCAL_NETWORK("clientsInLocalNetwork", "1"),

    @JsonProperty("clientsWithSamePublicIpAddress")
    CLIENTS_WITH_SAME_PUBLIC_IP_ADDRESS("clientsWithSamePublicIpAddress", "2"),

    @JsonProperty("clientsInCustomLocalNetworks")
    CLIENTS_IN_CUSTOM_LOCAL_NETWORKS("clientsInCustomLocalNetworks", "3"),

    @JsonProperty("clientsInCustomLocalNetworksWithFallback")
    CLIENTS_IN_CUSTOM_LOCAL_NETWORKS_WITH_FALLBACK("clientsInCustomLocalNetworksWithFallback", "4");

    private final String name;
    private final String value;

    private MacOSContentCachingClientPolicy(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
