package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum LostModeState implements Enum {

    @JsonProperty("disabled")
    DISABLED("disabled", "0"),

    @JsonProperty("enabled")
    ENABLED("enabled", "1");

    private final String name;
    private final String value;

    private LostModeState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
