package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum LongRunningOperationStatus implements Enum {

    @JsonProperty("notstarted")
    NOTSTARTED("notstarted", "0"),

    @JsonProperty("running")
    RUNNING("running", "1"),

    @JsonProperty("succeeded")
    SUCCEEDED("succeeded", "2"),

    @JsonProperty("failed")
    FAILED("failed", "3");

    private final String name;
    private final String value;

    private LongRunningOperationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
