package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum LocationType implements Enum {

    @JsonProperty("default")
    DEFAULT("default", "0"),

    @JsonProperty("conferenceRoom")
    CONFERENCE_ROOM("conferenceRoom", "1"),

    @JsonProperty("homeAddress")
    HOME_ADDRESS("homeAddress", "2"),

    @JsonProperty("businessAddress")
    BUSINESS_ADDRESS("businessAddress", "3"),

    @JsonProperty("geoCoordinates")
    GEO_COORDINATES("geoCoordinates", "4"),

    @JsonProperty("streetAddress")
    STREET_ADDRESS("streetAddress", "5"),

    @JsonProperty("hotel")
    HOTEL("hotel", "6"),

    @JsonProperty("restaurant")
    RESTAURANT("restaurant", "7"),

    @JsonProperty("localBusiness")
    LOCAL_BUSINESS("localBusiness", "8"),

    @JsonProperty("postalAddress")
    POSTAL_ADDRESS("postalAddress", "9");

    private final String name;
    private final String value;

    private LocationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
