package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum LocalSecurityOptionsStandardUserElevationPromptBehaviorType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("automaticallyDenyElevationRequests")
    AUTOMATICALLY_DENY_ELEVATION_REQUESTS("automaticallyDenyElevationRequests", "1"),

    @JsonProperty("promptForCredentialsOnTheSecureDesktop")
    PROMPT_FOR_CREDENTIALS_ON_THE_SECURE_DESKTOP("promptForCredentialsOnTheSecureDesktop", "2"),

    @JsonProperty("promptForCredentials")
    PROMPT_FOR_CREDENTIALS("promptForCredentials", "3");

    private final String name;
    private final String value;

    private LocalSecurityOptionsStandardUserElevationPromptBehaviorType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
