package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum LocalSecurityOptionsSmartCardRemovalBehaviorType implements Enum {

    @JsonProperty("lockWorkstation")
    LOCK_WORKSTATION("lockWorkstation", "0"),

    @JsonProperty("noAction")
    NO_ACTION("noAction", "1"),

    @JsonProperty("forceLogoff")
    FORCE_LOGOFF("forceLogoff", "2"),

    @JsonProperty("disconnectRemoteDesktopSession")
    DISCONNECT_REMOTE_DESKTOP_SESSION("disconnectRemoteDesktopSession", "3");

    private final String name;
    private final String value;

    private LocalSecurityOptionsSmartCardRemovalBehaviorType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
