package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum LocalSecurityOptionsMinimumSessionSecurity implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("requireNtmlV2SessionSecurity")
    REQUIRE_NTML_V2SESSION_SECURITY("requireNtmlV2SessionSecurity", "1"),

    @JsonProperty("require128BitEncryption")
    REQUIRE128BIT_ENCRYPTION("require128BitEncryption", "2"),

    @JsonProperty("ntlmV2And128BitEncryption")
    NTLM_V2AND128BIT_ENCRYPTION("ntlmV2And128BitEncryption", "3");

    private final String name;
    private final String value;

    private LocalSecurityOptionsMinimumSessionSecurity(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
