package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum LocalSecurityOptionsInformationDisplayedOnLockScreenType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("administrators")
    ADMINISTRATORS("administrators", "1"),

    @JsonProperty("administratorsAndPowerUsers")
    ADMINISTRATORS_AND_POWER_USERS("administratorsAndPowerUsers", "2"),

    @JsonProperty("administratorsAndInteractiveUsers")
    ADMINISTRATORS_AND_INTERACTIVE_USERS("administratorsAndInteractiveUsers", "3");

    private final String name;
    private final String value;

    private LocalSecurityOptionsInformationDisplayedOnLockScreenType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
