package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum LifecycleEventType implements Enum {

    @JsonProperty("missed")
    MISSED("missed", "0"),

    @JsonProperty("subscriptionRemoved")
    SUBSCRIPTION_REMOVED("subscriptionRemoved", "1"),

    @JsonProperty("reauthorizationRequired")
    REAUTHORIZATION_REQUIRED("reauthorizationRequired", "2");

    private final String name;
    private final String value;

    private LifecycleEventType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
