package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum LanguageProficiencyLevel implements Enum {

    @JsonProperty("elementary")
    ELEMENTARY("elementary", "0"),

    @JsonProperty("conversational")
    CONVERSATIONAL("conversational", "1"),

    @JsonProperty("limitedWorking")
    LIMITED_WORKING("limitedWorking", "2"),

    @JsonProperty("professionalWorking")
    PROFESSIONAL_WORKING("professionalWorking", "3"),

    @JsonProperty("fullProfessional")
    FULL_PROFESSIONAL("fullProfessional", "4"),

    @JsonProperty("nativeOrBilingual")
    NATIVE_OR_BILINGUAL("nativeOrBilingual", "5"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private LanguageProficiencyLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
