package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Label implements Enum {

    @JsonProperty("title")
    TITLE("title", "0"),

    @JsonProperty("url")
    URL("url", "1"),

    @JsonProperty("createdBy")
    CREATED_BY("createdBy", "2"),

    @JsonProperty("lastModifiedBy")
    LAST_MODIFIED_BY("lastModifiedBy", "3"),

    @JsonProperty("authors")
    AUTHORS("authors", "4"),

    @JsonProperty("createdDateTime")
    CREATED_DATE_TIME("createdDateTime", "5"),

    @JsonProperty("lastModifiedDateTime")
    LAST_MODIFIED_DATE_TIME("lastModifiedDateTime", "6"),

    @JsonProperty("fileName")
    FILE_NAME("fileName", "7"),

    @JsonProperty("fileExtension")
    FILE_EXTENSION("fileExtension", "8");

    private final String name;
    private final String value;

    private Label(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
