package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum KeyStorageProviderOption implements Enum {

    @JsonProperty("useTpmKspOtherwiseUseSoftwareKsp")
    USE_TPM_KSP_OTHERWISE_USE_SOFTWARE_KSP("useTpmKspOtherwiseUseSoftwareKsp", "0"),

    @JsonProperty("useTpmKspOtherwiseFail")
    USE_TPM_KSP_OTHERWISE_FAIL("useTpmKspOtherwiseFail", "1"),

    @JsonProperty("usePassportForWorkKspOtherwiseFail")
    USE_PASSPORT_FOR_WORK_KSP_OTHERWISE_FAIL("usePassportForWorkKspOtherwiseFail", "2"),

    @JsonProperty("useSoftwareKsp")
    USE_SOFTWARE_KSP("useSoftwareKsp", "3");

    private final String name;
    private final String value;

    private KeyStorageProviderOption(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
