package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum KeySize implements Enum {

    @JsonProperty("size1024")
    SIZE1024("size1024", "0"),

    @JsonProperty("size2048")
    SIZE2048("size2048", "1");

    private final String name;
    private final String value;

    private KeySize(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
