package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum KerberosSignOnMappingAttributeType implements Enum {

    @JsonProperty("userPrincipalName")
    USER_PRINCIPAL_NAME("userPrincipalName", "0"),

    @JsonProperty("onPremisesUserPrincipalName")
    ON_PREMISES_USER_PRINCIPAL_NAME("onPremisesUserPrincipalName", "1"),

    @JsonProperty("userPrincipalUsername")
    USER_PRINCIPAL_USERNAME("userPrincipalUsername", "2"),

    @JsonProperty("onPremisesUserPrincipalUsername")
    ON_PREMISES_USER_PRINCIPAL_USERNAME("onPremisesUserPrincipalUsername", "3"),

    @JsonProperty("onPremisesSAMAccountName")
    ON_PREMISES_SAMACCOUNT_NAME("onPremisesSAMAccountName", "4");

    private final String name;
    private final String value;

    private KerberosSignOnMappingAttributeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
