package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum JoinType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("azureADJoined")
    AZURE_ADJOINED("azureADJoined", "1"),

    @JsonProperty("azureADRegistered")
    AZURE_ADREGISTERED("azureADRegistered", "2"),

    @JsonProperty("hybridAzureADJoined")
    HYBRID_AZURE_ADJOINED("hybridAzureADJoined", "3");

    private final String name;
    private final String value;

    private JoinType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
