package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum IosWallpaperDisplayLocation implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("lockScreen")
    LOCK_SCREEN("lockScreen", "1"),

    @JsonProperty("homeScreen")
    HOME_SCREEN("homeScreen", "2"),

    @JsonProperty("lockAndHomeScreens")
    LOCK_AND_HOME_SCREENS("lockAndHomeScreens", "3");

    private final String name;
    private final String value;

    private IosWallpaperDisplayLocation(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
