package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum IosSoftwareUpdateScheduleType implements Enum {

    @JsonProperty("updateOutsideOfActiveHours")
    UPDATE_OUTSIDE_OF_ACTIVE_HOURS("updateOutsideOfActiveHours", "0"),

    @JsonProperty("alwaysUpdate")
    ALWAYS_UPDATE("alwaysUpdate", "1"),

    @JsonProperty("updateDuringTimeWindows")
    UPDATE_DURING_TIME_WINDOWS("updateDuringTimeWindows", "2"),

    @JsonProperty("updateOutsideOfTimeWindows")
    UPDATE_OUTSIDE_OF_TIME_WINDOWS("updateOutsideOfTimeWindows", "3");

    private final String name;
    private final String value;

    private IosSoftwareUpdateScheduleType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
