package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum InternetSiteSecurityLevel implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("medium")
    MEDIUM("medium", "1"),

    @JsonProperty("mediumHigh")
    MEDIUM_HIGH("mediumHigh", "2"),

    @JsonProperty("high")
    HIGH("high", "3");

    private final String name;
    private final String value;

    private InternetSiteSecurityLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
