package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum IntendedPurpose implements Enum {

    @JsonProperty("unassigned")
    UNASSIGNED("unassigned", "1"),

    @JsonProperty("smimeEncryption")
    SMIME_ENCRYPTION("smimeEncryption", "2"),

    @JsonProperty("smimeSigning")
    SMIME_SIGNING("smimeSigning", "3"),

    @JsonProperty("vpn")
    VPN("vpn", "4"),

    @JsonProperty("wifi")
    WIFI("wifi", "5");

    private final String name;
    private final String value;

    private IntendedPurpose(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
