package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum InferenceClassificationType implements Enum {

    @JsonProperty("focused")
    FOCUSED("focused", "0"),

    @JsonProperty("other")
    OTHER("other", "1");

    private final String name;
    private final String value;

    private InferenceClassificationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
