package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ImportedWindowsAutopilotDeviceIdentityImportStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("pending")
    PENDING("pending", "1"),

    @JsonProperty("partial")
    PARTIAL("partial", "2"),

    @JsonProperty("complete")
    COMPLETE("complete", "3"),

    @JsonProperty("error")
    ERROR("error", "4");

    private final String name;
    private final String value;

    private ImportedWindowsAutopilotDeviceIdentityImportStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
