package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ITunesPairingMode implements Enum {

    @JsonProperty("disallow")
    DISALLOW("disallow", "0"),

    @JsonProperty("allow")
    ALLOW("allow", "1"),

    @JsonProperty("requiresCertificate")
    REQUIRES_CERTIFICATE("requiresCertificate", "2");

    private final String name;
    private final String value;

    private ITunesPairingMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
