package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum HashAlgorithms implements Enum {

    @JsonProperty("sha1")
    SHA1("sha1", "1"),

    @JsonProperty("sha2")
    SHA2("sha2", "2");

    private final String name;
    private final String value;

    private HashAlgorithms(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
