package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum GroupPrivacy implements Enum {

    @JsonProperty("unspecified")
    UNSPECIFIED("unspecified", "0"),

    @JsonProperty("public")
    PUBLIC("public", "1"),

    @JsonProperty("private")
    PRIVATE("private", "2"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private GroupPrivacy(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
