package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum GroupPolicyType implements Enum {

    @JsonProperty("admxBacked")
    ADMX_BACKED("admxBacked", "0"),

    @JsonProperty("admxIngested")
    ADMX_INGESTED("admxIngested", "1");

    private final String name;
    private final String value;

    private GroupPolicyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
