package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum GroupPolicySettingType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("policy")
    POLICY("policy", "1"),

    @JsonProperty("account")
    ACCOUNT("account", "2"),

    @JsonProperty("securityOptions")
    SECURITY_OPTIONS("securityOptions", "3"),

    @JsonProperty("userRightsAssignment")
    USER_RIGHTS_ASSIGNMENT("userRightsAssignment", "4"),

    @JsonProperty("auditSetting")
    AUDIT_SETTING("auditSetting", "5"),

    @JsonProperty("windowsFirewallSettings")
    WINDOWS_FIREWALL_SETTINGS("windowsFirewallSettings", "6");

    private final String name;
    private final String value;

    private GroupPolicySettingType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
