package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum GroupPolicyOperationType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("upload")
    UPLOAD("upload", "1"),

    @JsonProperty("uploadNewVersion")
    UPLOAD_NEW_VERSION("uploadNewVersion", "2"),

    @JsonProperty("addLanguageFiles")
    ADD_LANGUAGE_FILES("addLanguageFiles", "3"),

    @JsonProperty("removeLanguageFiles")
    REMOVE_LANGUAGE_FILES("removeLanguageFiles", "4"),

    @JsonProperty("updateLanguageFiles")
    UPDATE_LANGUAGE_FILES("updateLanguageFiles", "5"),

    @JsonProperty("remove")
    REMOVE("remove", "6");

    private final String name;
    private final String value;

    private GroupPolicyOperationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
