package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum GroupPolicyOperationStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("inProgress")
    IN_PROGRESS("inProgress", "1"),

    @JsonProperty("success")
    SUCCESS("success", "2"),

    @JsonProperty("failed")
    FAILED("failed", "3");

    private final String name;
    private final String value;

    private GroupPolicyOperationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
