package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum GroupPolicyMigrationReadiness implements Enum {

    @JsonProperty("none")
    NONE("none", "1"),

    @JsonProperty("partial")
    PARTIAL("partial", "2"),

    @JsonProperty("complete")
    COMPLETE("complete", "3"),

    @JsonProperty("error")
    ERROR("error", "4"),

    @JsonProperty("notApplicable")
    NOT_APPLICABLE("notApplicable", "5");

    private final String name;
    private final String value;

    private GroupPolicyMigrationReadiness(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
