package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum GroupPolicyDefinitionClassType implements Enum {

    @JsonProperty("user")
    USER("user", "0"),

    @JsonProperty("machine")
    MACHINE("machine", "1");

    private final String name;
    private final String value;

    private GroupPolicyDefinitionClassType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
