package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum FreeBusyStatus implements Enum {

    @JsonProperty("free")
    FREE("free", "0"),

    @JsonProperty("tentative")
    TENTATIVE("tentative", "1"),

    @JsonProperty("busy")
    BUSY("busy", "2"),

    @JsonProperty("oof")
    OOF("oof", "3"),

    @JsonProperty("workingElsewhere")
    WORKING_ELSEWHERE("workingElsewhere", "4"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "-1");

    private final String name;
    private final String value;

    private FreeBusyStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
