package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum FirewallPacketQueueingMethodType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("disabled")
    DISABLED("disabled", "1"),

    @JsonProperty("queueInbound")
    QUEUE_INBOUND("queueInbound", "2"),

    @JsonProperty("queueOutbound")
    QUEUE_OUTBOUND("queueOutbound", "3"),

    @JsonProperty("queueBoth")
    QUEUE_BOTH("queueBoth", "4");

    private final String name;
    private final String value;

    private FirewallPacketQueueingMethodType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
