package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum FileVaultState implements Enum {

    @JsonProperty("success")
    SUCCESS("success", "0"),

    @JsonProperty("driveEncryptedByUser")
    DRIVE_ENCRYPTED_BY_USER("driveEncryptedByUser", "1"),

    @JsonProperty("userDeferredEncryption")
    USER_DEFERRED_ENCRYPTION("userDeferredEncryption", "2"),

    @JsonProperty("escrowNotEnabled")
    ESCROW_NOT_ENABLED("escrowNotEnabled", "4");

    private final String name;
    private final String value;

    private FileVaultState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
